function [f,g,H] = mu(lambda)

% benchmark function for numerical optimization
%
% lambda: function variable
% f: function value
% g: gradient

lambdastar=0.25;
mustar=0.6;

f=2.*mustar.*lambdastar.*lambda./(lambdastar.^2+lambda.^2);   % Objective function value
f=-f;

if nargout > 1                   % gradient
   g=2*mustar*lambdastar/(lambdastar^2+lambda^2)-4*mustar*lambdastar*lambda^2/(lambdastar^2+lambda^2)^2;
   g=-g;
end

if nargout > 1                 % Hessian
   H=2*mustar*lambdastar*(-2*lambda)/((lambdastar^2+lambda^2)^2)-8*mustar*lambdastar*lambda/(lambdastar^2+lambda^2)^2+16*mustar*lambdastar*lambda^3/(lambdastar^2+lambda^2)^3;
   H=-H;
end


 